'''
Created on 8.1.2018

@author: PRORJM
'''

class EnergyStorage(object):

    def __init__(self, cap, loss, load, unload, inv, tech, dT):
        self.capacity = cap
        self.losses = loss
        self.initCharge = 0
        self.loadingCost = 0.00001
        self.unloadingCost = 0.00001
        self.load = []
        self.unload = []
        self.cycles = 0
        
        # specific investment 
        self.spec_inv = inv
        # temperature difference (valid for water based storages)
        self.dT = dT
        
        # technology (what is stored)
        self.tech = tech
        
        # life time
        lt = 20
        self.lifetime = lt
        
        # load/unload per storage capacity, ratio has to be 1 or lower
        if self.capacity > 0:
            self.loadingRatio = min(load/self.capacity, 1)  
            self.unloadingRatio = min(unload/self.capacity, 1)
        else:
            self.loadingRatio = 1  
            self.unloadingRatio = 1
            
        self.loadingEff = 1
        self.unloadingEff = 1

    def calculateInvestment(self):
        return self.capacity*self.spec_inv